//
//  OPEntity.h
//  The Obfuscated Path
//
//  Created by ss2cire on 12/27/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "OPSprite.h"

@interface OPEntity : OPSprite
{
	NSMutableDictionary *textures;
	OPPoint		velocity;

	int			maxHealth;
	int			currentHealth;
	
	int			attack;
	int			defense;
	
	BOOL		movingUp;
	BOOL		movingDown;
	BOOL		movingLeft;
	BOOL		movingRight;
	
	
}
- (void)addTextureID:(GLuint)theID withName:(NSString *)name;
- (GLuint)textureWithName:(NSString *)textureName;

- (void)setMovingLeft:(BOOL)value;
- (void)setMovingRight:(BOOL)value;
- (void)setMovingUp:(BOOL)value;
- (void)setMovingDown:(BOOL)value;

- (BOOL)isMovingUp;
- (BOOL)isMovingDown;
- (BOOL)isMovingLeft;
- (BOOL)isMovingRight;

- (void)stop;
- (void)stopHorizontal;
- (void)stopVertical;

- (BOOL)isMoving;
- (BOOL)isMovingHorizontal;
- (BOOL)isMovingVertical;

- (BOOL)checkCollision:(OPSprite *)spriteToCheck;

- (BOOL)hurt;
- (void)heal;

- (int)attack;
- (int)defense;
- (int)currentHealth;
- (int)maxHealth;

- (OPDirection)movingDirection;


@end
